/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.rest;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pusher.rest.SignatureUtil;
import com.pusher.rest.data.AuthData;
import com.pusher.rest.data.Event;
import com.pusher.rest.data.EventBatch;
import com.pusher.rest.data.PresenceUser;
import com.pusher.rest.data.Result;
import com.pusher.rest.data.TriggerData;
import com.pusher.rest.data.Validity;
import com.pusher.rest.util.Prerequisites;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pusher {
    private static final Gson BODY_SERIALISER = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final Pattern HEROKU_URL = Pattern.compile("(https?)://(.+):(.+)@(.+:?.*)/apps/(.+)");
    private final String appId;
    private final String key;
    private final String secret;
    private String host = "api.pusherapp.com";
    private String scheme = "http";
    private int requestTimeout = 4000;
    private CloseableHttpClient client;
    private Gson dataMarshaller;

    public Pusher(String appId, String key, String secret) {
        Prerequisites.nonEmpty("appId", appId);
        Prerequisites.nonEmpty("key", key);
        Prerequisites.nonEmpty("secret", secret);
        Prerequisites.isValidSha256Key("secret", secret);
        this.appId = appId;
        this.key = key;
        this.secret = secret;
        this.configure();
    }

    public Pusher(String url) {
        Prerequisites.nonNull("url", url);
        Matcher m = HEROKU_URL.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException("URL '" + url + "' does not match pattern '<scheme>://<key>:<secret>@<host>[:<port>]/apps/<appId>'");
        }
        this.scheme = m.group(1);
        this.key = m.group(2);
        this.secret = m.group(3);
        this.host = m.group(4);
        this.appId = m.group(5);
        Prerequisites.isValidSha256Key("secret", this.secret);
        this.configure();
    }

    private void configure() {
        this.configureHttpClient(Pusher.defaultHttpClientBuilder());
        this.dataMarshaller = new Gson();
    }

    public void setHost(String host) {
        Prerequisites.nonNull("host", host);
        this.host = host;
    }

    public void setCluster(String cluster) {
        Prerequisites.nonNull("cluster", cluster);
        this.host = "api-" + cluster + ".pusher.com";
    }

    public void setEncrypted(boolean encrypted) {
        this.scheme = encrypted ? "https" : "http";
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setGsonSerialiser(Gson gson) {
        this.dataMarshaller = gson;
    }

    public static HttpClientBuilder defaultHttpClientBuilder() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).disableRedirectHandling();
    }

    public void configureHttpClient(HttpClientBuilder builder) {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.client = builder.build();
    }

    protected String serialise(Object data) {
        return this.dataMarshaller.toJson(data);
    }

    public Result trigger(String channel, String eventName, Object data) {
        return this.trigger(channel, eventName, data, null);
    }

    public Result trigger(List<String> channels, String eventName, Object data) {
        return this.trigger(channels, eventName, data, null);
    }

    public Result trigger(String channel, String eventName, Object data, String socketId) {
        return this.trigger(Collections.singletonList(channel), eventName, data, socketId);
    }

    public Result trigger(List<String> channels, String eventName, Object data, String socketId) {
        Prerequisites.nonNull("channels", channels);
        Prerequisites.nonNull("eventName", eventName);
        Prerequisites.nonNull("data", data);
        Prerequisites.maxLength("channels", 10, channels);
        Prerequisites.noNullMembers("channels", channels);
        Prerequisites.areValidChannels(channels);
        Prerequisites.isValidSocketId(socketId);
        String body = BODY_SERIALISER.toJson((Object)new TriggerData(channels, eventName, this.serialise(data), socketId));
        return this.post("/events", body);
    }

    public Result trigger(List<Event> batch) {
        ArrayList<Event> eventsWithSerialisedBodies = new ArrayList<Event>(batch.size());
        for (Event e : batch) {
            eventsWithSerialisedBodies.add(new Event(e.getChannel(), e.getName(), this.serialise(e.getData()), e.getSocketId()));
        }
        String body = BODY_SERIALISER.toJson((Object)new EventBatch(eventsWithSerialisedBodies));
        return this.post("/batch_events", body);
    }

    public Result get(String path) {
        return this.get(path, Collections.<String, String>emptyMap());
    }

    public Result get(String path, Map<String, String> parameters) {
        String fullPath = "/apps/" + this.appId + path;
        URI uri = SignatureUtil.uri("GET", this.scheme, this.host, fullPath, null, this.key, this.secret, parameters);
        return this.httpCall((HttpRequestBase)new HttpGet(uri));
    }

    public Result post(String path, String body) {
        String fullPath = "/apps/" + this.appId + path;
        URI uri = SignatureUtil.uri("POST", this.scheme, this.host, fullPath, body, this.key, this.secret, Collections.<String, String>emptyMap());
        StringEntity bodyEntity = new StringEntity(body, "UTF-8");
        bodyEntity.setContentType("application/json");
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)bodyEntity);
        return this.httpCall((HttpRequestBase)request);
    }

    Result httpCall(HttpRequestBase request) {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(this.requestTimeout).setConnectionRequestTimeout(this.requestTimeout).setConnectTimeout(this.requestTimeout).build();
        request.setConfig(config);
        try {
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)baos);
            String responseBody = new String(baos.toByteArray(), "UTF-8");
            return Result.fromHttpCode(response.getStatusLine().getStatusCode(), responseBody);
        }
        catch (IOException e) {
            return Result.fromException(e);
        }
    }

    public URI signedUri(String method, String path, String body) {
        return this.signedUri(method, path, body, Collections.<String, String>emptyMap());
    }

    public URI signedUri(String method, String path, String body, Map<String, String> parameters) {
        return SignatureUtil.uri(method, this.scheme, this.host, path, body, this.key, this.secret, parameters);
    }

    public String authenticate(String socketId, String channel) {
        Prerequisites.nonNull("socketId", socketId);
        Prerequisites.nonNull("channel", channel);
        Prerequisites.isValidChannel(channel);
        Prerequisites.isValidSocketId(socketId);
        if (channel.startsWith("presence-")) {
            throw new IllegalArgumentException("This method is for private channels, use authenticate(String, String, PresenceUser) to authenticate for a presence channel.");
        }
        if (!channel.startsWith("private-")) {
            throw new IllegalArgumentException("Authentication is only applicable to private and presence channels");
        }
        String signature = SignatureUtil.sign(socketId + ":" + channel, this.secret);
        return BODY_SERIALISER.toJson((Object)new AuthData(this.key, signature));
    }

    public String authenticate(String socketId, String channel, PresenceUser user) {
        Prerequisites.nonNull("socketId", socketId);
        Prerequisites.nonNull("channel", channel);
        Prerequisites.nonNull("user", user);
        Prerequisites.isValidChannel(channel);
        Prerequisites.isValidSocketId(socketId);
        if (channel.startsWith("private-")) {
            throw new IllegalArgumentException("This method is for presence channels, use authenticate(String, String) to authenticate for a private channel.");
        }
        if (!channel.startsWith("presence-")) {
            throw new IllegalArgumentException("Authentication is only applicable to private and presence channels");
        }
        String channelData = BODY_SERIALISER.toJson((Object)user);
        String signature = SignatureUtil.sign(socketId + ":" + channel + ":" + channelData, this.secret);
        return BODY_SERIALISER.toJson((Object)new AuthData(this.key, signature, channelData));
    }

    public Validity validateWebhookSignature(String xPusherKeyHeader, String xPusherSignatureHeader, String body) {
        if (!xPusherKeyHeader.trim().equals(this.key)) {
            return Validity.SIGNED_WITH_WRONG_KEY;
        }
        String recalculatedSignature = SignatureUtil.sign(body, this.secret);
        return xPusherSignatureHeader.trim().equals(recalculatedSignature) ? Validity.VALID : Validity.INVALID;
    }
}

