/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.rest.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Prerequisites {
    private static final Pattern VALID_CHANNEL = Pattern.compile("\\A[-a-zA-Z0-9_=@,.;]+\\z");
    private static final Pattern VALID_SOCKET_ID = Pattern.compile("\\A\\d+\\.\\d+\\z");
    private static final Set<String> RESERVED_QUERY_KEYS = new HashSet<String>(Arrays.asList("auth_key", "auth_timestamp", "auth_version", "auth_signature", "body_md5"));

    public static void nonNull(String name, Object ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Parameter [" + name + "] must not be null");
        }
    }

    public static void nonEmpty(String name, String ref) {
        Prerequisites.nonNull(name, ref);
        if (ref.length() == 0) {
            throw new IllegalArgumentException("Parameter [" + name + "] must not be empty");
        }
    }

    public static void maxLength(String name, int max, List<?> ref) {
        if (ref.size() > max) {
            throw new IllegalArgumentException("Parameter [" + name + "] must have size < " + max);
        }
    }

    public static void noNullMembers(String name, List<?> ref) {
        for (Object e : ref) {
            if (e != null) continue;
            throw new IllegalArgumentException("Parameter [" + name + "] must not contain null elements");
        }
    }

    public static void noReservedKeys(Map<String, String> params) {
        for (String k : params.keySet()) {
            if (!RESERVED_QUERY_KEYS.contains(k.toLowerCase())) continue;
            throw new IllegalArgumentException("Query parameter key [" + k + "] is reserved and should not be submitted. It will be generated by the signature generation.");
        }
    }

    public static void isValidSha256Key(String name, String key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key.getBytes(), "SHA256"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The Pusher HTTP client requires HmacSHA256 support", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Parameter [" + name + "] must be a valid SHA256 key", e);
        }
    }

    public static void areValidChannels(List<String> channels) {
        for (String channel : channels) {
            Prerequisites.isValidChannel(channel);
        }
    }

    public static void isValidChannel(String channel) {
        Prerequisites.matchesRegex("channel", VALID_CHANNEL, channel);
    }

    public static void isValidSocketId(String socketId) {
        if (socketId != null) {
            Prerequisites.matchesRegex("socket_id", VALID_SOCKET_ID, socketId);
        }
    }

    private static void matchesRegex(String name, Pattern regex, String toMatch) {
        Prerequisites.nonNull(name, toMatch);
        if (!regex.matcher(toMatch).matches()) {
            throw new IllegalArgumentException(name + " [" + toMatch + "] is not valid");
        }
    }
}

