/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.google;

import com.google.appengine.repackaged.com.google.common.flogger.backend.google.HighPrecisionClock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.Clock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.Configuration;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.DefaultPlatform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.LoggingContext;

public final class GooglePlatform
extends DefaultPlatform {
    private static final String CONTEXT_IMPL = "com.google.appengine.repackaged.com.google.common.flogger.config.TraceLoggingContext";
    private static final String CONTEXT_GETTER = "getInstance";

    @Override
    protected void configure(Configuration config) {
        LoggingContext context;
        super.configure(config);
        Clock highPrecisionClock = HighPrecisionClock.getInstance();
        if (highPrecisionClock != null) {
            config.setClock(highPrecisionClock);
        }
        if ((context = GooglePlatform.callStaticGetter(CONTEXT_IMPL, CONTEXT_GETTER, LoggingContext.class)) != null) {
            config.setLoggingContext(context);
        }
    }

    private static <T> T callStaticGetter(String className, String methodName, Class<T> targetType) {
        try {
            return targetType.cast(Class.forName(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ReflectiveOperationException | SecurityException e) {
            System.err.format("error calling expected no-argument static method %s.%s: %s\n", className, methodName, e);
            e.printStackTrace(System.err);
        }
        catch (ClassCastException e) {
            System.err.format("cannot cast result of call %s.%s to expected type %s: %s\n", className, methodName, targetType.getName(), e);
            e.printStackTrace(System.err);
        }
        return null;
    }
}

