/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.appengine.repackaged.com.google.common.util.concurrent.RateLimiter;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GoogleInternal
@GwtIncompatible
final class RateLimitingExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    private final ListeningScheduledExecutorService delegate;
    private final RateLimiter rateLimiter;
    private final int permitsPerTask;

    RateLimitingExecutorService(RateLimiter rateLimiter, ListeningScheduledExecutorService scheduledExecutorService, int permitsPerTask) {
        Preconditions.checkArgument(permitsPerTask > 0, "Requested permitsPerTask must be positive");
        this.rateLimiter = rateLimiter.checkSupportsAsync();
        this.delegate = Preconditions.checkNotNull(scheduledExecutorService);
        this.permitsPerTask = permitsPerTask;
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, @NullableDecl T result) {
        Preconditions.checkNotNull(task);
        return this.delegate.schedule(Executors.callable(task, result), this.rateLimiter.reserve(this.permitsPerTask), TimeUnit.MICROSECONDS);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        Preconditions.checkNotNull(task);
        return this.delegate.schedule(task, this.rateLimiter.reserve(this.permitsPerTask), TimeUnit.MICROSECONDS);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        Preconditions.checkNotNull(task);
        return this.delegate.schedule(task, this.rateLimiter.reserve(this.permitsPerTask), TimeUnit.MICROSECONDS);
    }

    @Override
    public void execute(Runnable command) {
        Preconditions.checkNotNull(command);
        ListenableScheduledFuture<?> possiblyIgnoredError = this.delegate.schedule(command, this.rateLimiter.reserve(this.permitsPerTask), TimeUnit.MICROSECONDS);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @CanIgnoreReturnValue
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(time, unit);
    }
}

