/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.DatastoreV4Client;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.EntityV4;
import java.util.List;

class AllocateIdsHandler
extends DatastoreRpcHandler<DatastoreService.AllocateIdsRequest, DatastoreService.AllocateIdsResponse, DatastoreV4Client> {
    private final EntityV4Normalizer entityNormalizer;
    private final int maxKeysPerBatch;

    public AllocateIdsHandler(DatastoreV4Client datastoreClient, EntityV4Normalizer entityNormalizer, int maxKeysPerBatch) {
        super(datastoreClient);
        this.entityNormalizer = entityNormalizer;
        this.maxKeysPerBatch = maxKeysPerBatch;
    }

    @Override
    public Parser<DatastoreService.AllocateIdsRequest> getParser() {
        return DatastoreService.AllocateIdsRequest.parser();
    }

    @Override
    public Class<DatastoreService.AllocateIdsRequest> getRequestClass() {
        return DatastoreService.AllocateIdsRequest.class;
    }

    @Override
    public DatastoreService.AllocateIdsResponse call(RpcHandler.CallOptions callOptions, DatastoreService.AllocateIdsRequest req) throws RpcException {
        List<EntityV4.Key> normalizedKeys = Lists.transform(req.getKeyList(), this.entityNormalizer.getKeyTransform());
        return ((DatastoreV4Client)this.datastoreClient).allocateIds(callOptions, this.maxKeysPerBatch, normalizedKeys);
    }

    @Override
    public DatastoreService.AllocateIdsResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.AllocateIdsResponse.newBuilder().setHeader(AllocateIdsHandler.makeErrorHeader(errorCode, message)).build();
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(DatastoreService.AllocateIdsRequest request) {
        return RpcHandler.RequestPermissions.READ_WRITE;
    }
}

