<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model common\models\User */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="user-form">

    <?php $form = ActiveForm::begin();
    $clients = \common\models\Client::find()->all();

    $items = ArrayHelper::map($clients,'id','clientName');
    $params = [
        'prompt' => '-- Select client --'
    ];

    $stensils = \common\models\Stencil::find()->all();

    $itemStencils = ArrayHelper::map($stensils,'id','stencilName');
    $paramStencils = [
        'prompt' => '-- Select stencil --'
    ];
    ?>

    <?= $form->field($model, 'userfullname')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'username')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>


    <?= $form->field($model, 'status')->dropDownList([
    '10' => 'Active',
    '9' => 'Inactive'
    ])?>

    <?= $form->field($model, 'maxSession')->textInput(['type' => 'number']) ?>

   <?php
    echo $form->field($model, 'userStencilid')->dropDownList($itemStencils,$paramStencils);
    ?>


    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
