<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\UserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title =  Yii::$app->user->identity->getClientName() . ' Users';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="row-full" >

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create User', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            'id',
            'userfullname',
            'email:email',
            'username',

            [
                    'class' => 'yii\grid\ActionColumn',
                'header'=>'',
                'template' => '{psw} {template}',
                'buttons' => [
                    'psw' => function ($url,$model) {
                        return Html::a(
                            '<span class="glyphicon glyphicon-lock"></span>',
                            $url);
                    },
                    'template' => function ($url,$model) {
                        return Html::a(
                            '<span class="glyphicon glyphicon-list-alt"></span>',
                            $url);
                    },
                  ],
            ],
            [   'attribute' => 'last_login',
                'format' => ['date','dd/MM/Y HH:mm:ss'],
            ],
             'totSession',
             [
                'attribute'=>'userStencilid',
                'format'=>'text',
                'content'=>function($data){
                    return $data->getStencilName();
                },
                'filter' => \common\models\User::getStencilList()
            ],
//            'auth_key',
//            'password_hash',
//            'password_reset_token',

            [
                'attribute'=>'status',
                'filter'=>array("10"=>"Yes","9"=>"No"),

                'value' => function($model) { return $model->status == 10 ? 'Yes' : 'No';}

            ],

            'maxSession',
            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>


</div>
