<?php

namespace common\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "events".
 *
 * @property int $id
 * @property string $eventName
 * @property string $xmlCode
 * @property int $created_at
 * @property int $updated_at
 * @property string $eventdate
 * @property int $userid
 * @property int $eventActive
 * @property string $imageCode
 * @property string $eventInfo
 */
class Event extends \yii\db\ActiveRecord
{

    public $future_event =0;
    public $last_event =0;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'events';
    }

    public function behaviors()
    {
        return [
            TimestampBehavior::className(),
        ];
    }
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['eventName', 'xmlCode', 'created_at', 'updated_at', 'eventdate','userid'], 'required'],
            [['xmlCode','imageCode','eventInfo'], 'string'],
            [['created_at', 'updated_at','userid','eventActive'], 'integer'],
            [['eventdate'], 'safe'],
            [['eventName'], 'string', 'max' => 100],
        ];
    }

    public static function findByID($id) {
        return static::findOne(['id' => $id, 'eventActive' => 1]);
    }

    public static function findByIDAll($id) {
        return static::findOne(['id' => $id]);
    }

    public static function findByName($eventname,$userid) {
        return static::findOne(['eventName' => $eventname, 'userid' => $userid, 'eventActive' => 1]);
    }

    public static function getUserEvents($userid, $includeImages)
    {
        //return all events for current user and all users the same company as user
        $evnts = \common\models\Event::find()
            ->select(['id', 'eventName','eventdate','userid','updated_at','eventActive','imageCode'])
            ->where(['eventActive' => 1])
            ->orderBy(['updated_at' => SORT_DESC])->all();

        $arrlength = count($evnts);
        $userInfo = \common\models\User::findIdentity($userid);

        $userClientID = \common\models\Client::findIdentity($userInfo->clientid);

        //if there is company for this user
        if ($userClientID)
        {
            $users = \common\models\User::find()
                ->select(['id','userfullname'])
                ->where(['clientid' => $userInfo->clientid])
                ->orderBy(['id' => SORT_ASC])->all();
        }
        else
        {
            $users = \common\models\User::find()
                ->select(['id','userfullname'])
                ->where(['id' => $userid])
                ->orderBy(['id' => SORT_ASC])->all();
        }

        $userlength = count($users);


        //now copy all need events to new array
        $evntsFiltered = [];
        $formatter = \Yii::$app->formatter;
        $formatter->dateFormat = 'yyyy-MM-dd';

        for($x = 0; $x < $arrlength; $x++) {
            for($y = 0; $y < $userlength; $y++) {
                if ($evnts[$x]->userid ==$users[$y]->id){
                    //replace userid with full name
                    $evnts[$x]->userid = $users[$y]->userfullname;
                    //replace updated_at with correct date format
                    $evnts[$x]->updated_at = $formatter->asDate($evnts[$x]->updated_at);

                    //if no need image, clear it value
                    if (!$includeImages) {
                        $evnts[$x]->imageCode = '';
                    }


                    //eventActive will show is it no event date(0), future(1) or past(-1)
                    if ( $evnts[$x]->eventdate == null)
                    {
                        $evnts[$x]->eventActive = 0;
                    }
                    else if ( $evnts[$x]->eventdate > date('Y-m-d'))
                    {
                        $evnts[$x]->eventActive = 1;
                    }
                    else
                    {
                        $evnts[$x]->eventActive = -1;
                    }
                    array_push($evntsFiltered,$evnts[$x])  ;
                    break;
                }
            }
        }

        return  $evntsFiltered;



    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'eventName' => 'Event Name',
            'xmlCode' => 'Xml Code',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'eventdate' => 'Event Date',
            'userid' => 'User',
            'eventActive' => 'Event Active',
            'imageCode' => 'Image',
            'eventInfo' => 'Event Info'
        ];
    }
}
