<?php

namespace common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Stencil;

/**
 * StencilSearch represents the model behind the search form of `common\models\Stencil`.
 */
class StencilSearch extends Stencil
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'created_at', 'updated_at', 'stencilActive','isMasterStencil','stencilOrder'], 'integer'],
            [['stencilName', 'stencilXML'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Stencil::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'stencilActive' => $this->stencilActive,
            'isMasterStencil' => $this->isMasterStencil,
            'stencilOrder' => $this->stencilOrder,
        ]);

        $query->andFilterWhere(['like', 'stencilName', $this->stencilName])
            ->andFilterWhere(['like', 'stencilXML', $this->stencilXML]);

        return $dataProvider;
    }
}
