<?php

namespace common\models;

use FontLib\Table\Type\name;
use Yii;
use yii\behaviors\TimestampBehavior;
use yii\helpers\ArrayHelper;
use yii\web\UploadedFile;
use yii\helpers\FileHelper;


/**
 * This is the model class for table "xmltemplate".
 *
 * @property int $id
 * @property string $templateName
 * @property string $xmlCode
 * @property int $templateActive
 * @property integer $created_at
 * @property integer $updated_at
 * @property int $templateDefault
 * @property int $clientid
 * @property int $shadow
 * @property string $image
 * @property string $templateSize
 */
class Template extends \yii\db\ActiveRecord
{
    public $imageFile;
    public $subtemplate;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'xmltemplate';
    }

    public static function getUserTemplates($userid)
    {

        $tmpls = \common\models\Template::find()
            ->select(['id', 'clientid','templateName','templateDefault'])
            ->where(['templateActive' => 1])
            ->orderBy(['templateName' => SORT_ASC, 'updated_at' => SORT_DESC])->all();

     

        $userTemplates = \common\models\UserTemplates::findAll([
            'userid' => $userid,
        ]);
        $userInfo = \common\models\User::findIdentity($userid);

        $arrlength = count($tmpls);
        $tmpllength = count($userTemplates);

        $tmplNames = "";

        $userClientID = \common\models\Client::findIdentity($userInfo->clientid);
        $userClientStatus = 9; //trial
        
        if ($userClientID)
        {
            $userClientName = $userClientID->clientName;
            $userClientStatus =$userClientID->status ;

            //set template clientid as current clientid if this template assigned to client
            for($x = 0; $x < $arrlength; $x++) {
                $clientTemplates = \common\models\ClientTemplates::findAll([
                    'clientid' => $userClientID->id,
                    'templateid' =>$tmpls[$x]->id,
                ]);
                if ($clientTemplates)
                {
                    $tmpls[$x]->clientid =-1;
                }
            }
        }
        else
        {
            $userClientName = "";
        }

        $lastTemplateName = '';
        for($x = 0; $x < $arrlength; $x++) {

            if ($tmpls[$x]->templateName != $lastTemplateName) {
                $lastTemplateName = $tmpls[$x]->templateName;
            //check is this template clientid is the same as user clientid
            if ( ($tmpls[$x]->clientid == -1) || ($tmpls[$x]->clientid != null) && ($tmpls[$x]->clientid == $userInfo->clientid)) {
                $tmplNames = $tmplNames . $tmpls[$x]->id . "|" . '!' . $tmpls[$x]->templateName . "|";
            } else {
                //add all default templates for trial users only
                if ($tmpls[$x]->templateDefault == 1 && $userClientStatus != 10) {
                    $tmplNames = $tmplNames . $tmpls[$x]->id . "|" . $tmpls[$x]->templateName . "|";
                } else {
                    //check is this user is Admin or Support (except google templates
                    if (($userInfo->userIsAdmin || $userInfo->userIsSupport) && strpos(strtoupper($tmpls[$x]->templateName),'OOGLE') == false)
                    {
                        $tmplNames = $tmplNames . $tmpls[$x]->id . "|" . $tmpls[$x]->templateName . "|";
                    }
                    else {
                        //check is this template assigned to this user
                        for ($y = 0; $y < $tmpllength; $y++) {
                            if ($tmpls[$x]->id == $userTemplates[$y]->templateid) {
                                $tmplNames = $tmplNames . $tmpls[$x]->id . "|" . $tmpls[$x]->templateName . "|";
                            }
                        }
                    }
                }
            }
         }
        }

        $retr_arr["tmplNames"] = $tmplNames;
        $retr_arr["clientName"] = $userClientName;

        return $retr_arr;
    }
    /**
     * {@inheritdoc}
     */

    public static function findByID($id) {
        return static::findOne(['id' => $id,]);
    }

    public function behaviors()
    {
        return [
            TimestampBehavior::className(),
        ];
    }

    public function getClientName()
    {
        $Client=Client::findOne(['id' => $this->clientid]);
        if ($Client){
            return $Client->clientName;
        }
        else{
            return null;
        }
    }

    public static function getClientList()
    {
        //$clients = \common\models\Client::find()->all();

        $clients = \common\models\Client::find()
            ->select(['id', 'clientName'])
            ->orderBy(['clientName' => SORT_ASC])->all();

        $items = ArrayHelper::map($clients,'id','clientName');
        return $items;
    }

    public static function getSizeList()
    {
        $info = array('Any size','less 20 KB','more 20 KB',  'more 50 KB', 'more 100 KB', 'more 1 MB', 'more 10 MB');

// Listing all the variables
        list($drink, $color, $power) = $info;

        $clients = \common\models\Client::find()
            ->select(['id', 'clientName'])
            ->orderBy(['clientName' => SORT_ASC])->all();

        $items = ArrayHelper::map($clients,'id','clientName');
        return $info;
    }

    public function rules()
    {
        return [
            [['templateName', 'xmlCode'], 'required'],
            [['xmlCode'], 'string'],
            [['templateActive','templateDefault','clientid','shadow'], 'integer'],
            ['templateActive', 'default', 'value' => 1],
            [['templateName'], 'string', 'max' => 100],
            [['imageFile'], 'file', 'skipOnEmpty' => false, 'extensions' => 'png, jpg, jpeg, gif'],
            [['image'], 'string'],
            ['image', 'default', 'value' => ''],
            ['templateSize', 'default', 'value' => 0],
            ['subtemplate', 'validateSubtemplate', 'skipOnEmpty' => true],
         ];
    }

    public function validateSubtemplate($attribute)
    {
        $requiredValidator = new RequiredValidator();

//        foreach($this->$attribute as $index => $row) {
//            $error = null;
//            foreach (['subtemplatename', 'xmlCode'] as $name) {
//                $error = null;
//                $value = isset($row[$name]) ? $row[$name] : null;
//                $requiredValidator->validate($value, $error);
//                if (!empty($error)) {
//                    $key = $attribute . '[' . $index . '][' . $name . ']';
//                    $this->addError($key, $error);
//                }
//            }
//        }
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'templateName' => 'Template Name',
            'xmlCode' => 'Xml Code',
            'templateActive' => 'Active',
            'created_at'=> 'Created',
            'updated_at'=> 'Updated',
            'templateDefault' => 'Default',
            'clientid' => 'Client',
            'shadow' => 'Shadow',
            'imageFile' => 'Template image',
            'image' => 'Image file name',
            'templateSize' => 'Size (KB)'
        ];
    }

    public function init() {
        parent::init ();
        $this->templateActive  = 1;
    }

    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {

            $this->templateSize = round(strlen($this->xmlCode) / 1024, 2);
            return true;
        } else {
            return false;
        }

    }

}
