<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "threed".
 *
 * @property int $id
 * @property int $objectType
 * @property int $objectId
 * @property string $threedValue
 * @property string $token
 */
class Threed extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'threed';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['objectType', 'objectId'], 'required'],
            [['objectType', 'objectId'], 'integer'],
            [['threedValue'], 'string'],
            [['token'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */

    public static function findByType_and_ID($objectType,$objectID) {
        return static::findOne(['objectType' => $objectType, 'objectId' => $objectID]);
    }

    public static function findByToken($token) {
        return static::findOne(['token' => $token]);
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'objectType' => 'Object Type',
            'objectId' => 'Object ID',
            'threedValue' => 'Threed Value',
            'token' => 'Token',
        ];
    }
}
