<?php

/* @var $this yii\web\View */

use yii\helpers\Html;

$this->title = 'Connect to Eventdraw broadcast';
$this->params['breadcrumbs'][] = $this->title;

$broadcast_id = $_GET['id'];

?>

<div class="site-about">
    <h1><?= Html::encode($this->title) ?></h1>
</div>

        <table class="control">
            <tr>
                <td class="title">Status:</td>
                <td class="title">Messages:</td>
            </tr>
            <tr>
                <td>
                    <input type="text" id="sendMessageBox" placeholder="Enter a message..." autofocus="true" />
                    <button type="button" id="sendButton">Send</button>
                    <button type="button" id="clearMsgsButton">Clear Msgs (Local)</button>
                </td>
            </tr>
            <tr>
                <td><div id="status" class="status"></div></td>
                <td><div class="message" id="message"></div></td>
            </tr>
            <tr>
                <button type="button" class="control-button" id="callButton">Call</button>
                <canvas id='canvasED'>
                </canvas>  

                
                <video playsinline autoplay></video>
            </tr>
            

        </table>

        <script src="/test/peerjs.min.js"></script>
        <script type="text/javascript">
            (function () {

                var lastPeerId = null;
                var peer = null; // own peer object
                var conn = null;
                var recvIdInput = document.getElementById("receiver-id");
                var status = document.getElementById("status");
                var message = document.getElementById("message");
                var cueString = "<span class=\"cueMsg\">Cue: </span>";
              
                var callButton = document.getElementById("callButton");
                var sendButton = document.getElementById("sendButton");
                const video = document.querySelector('video');
                const canvas = document.getElementById('canvasED');
                const stream = canvas.captureStream();

                //canvas draw code
                var canvasObj = document.getElementById('canvasED');
               
              

                /**
                 * Create the Peer object for our end of the connection.
                 *
                 * Sets up callbacks that handle any events related to our
                 * peer object.
                 */
                function initialize() {
                    // Create own peer object with connection to shared PeerJS server
                    peer = new Peer(null, {
                        debug: 2
                    });

                    peer.on('open', function (id) {
                        // Workaround for peer.reconnect deleting previous id
                        if (peer.id === null) {
                            console.log('Received null id from peer open');
                            peer.id = lastPeerId;
                        } else {
                            lastPeerId = peer.id;
                        }

                        console.log('ID: ' + peer.id);
                    });
                    peer.on('connection', function (c) {
                        // Disallow incoming connections
                        c.on('open', function() {
                            c.send("Sender does not accept incoming connections");
                            setTimeout(function() { c.close(); }, 500);
                        });
                    });
                    peer.on('disconnected', function () {
                        status.innerHTML = "Connection lost. Please reconnect";
                        console.log('Connection lost. Please reconnect');

                        // Workaround for peer.reconnect deleting previous id
                        peer.id = lastPeerId;
                        peer._lastServerId = lastPeerId;
                        peer.reconnect();
                    });
                    peer.on('close', function() {
                        conn = null;
                        status.innerHTML = "Connection destroyed. Please refresh";
                        console.log('Connection destroyed');
                    });
                    peer.on('error', function (err) {
                        console.log(err);
                        alert('' + err);
                    });
                };

                /**
                 * Create the connection between the two Peers.
                 *
                 * Sets up callbacks that handle any events related to the
                 * connection and data received on it.
                 */
                function join() {
                    // Close old connection
                    if (conn) {
                        conn.close();
                    }

                    // Create connection to destination peer specified in the input field
                    

                    conn = peer.connect("<?php echo $broadcast_id ?>", {
                        reliable: true
                    });

                    conn.on('open', function () {
                        status.innerHTML = "Connected to broadcast" ;
                        console.log("Connected to: " + conn.peer);

                      
                    });
                    // Handle incoming data (messages only since this is the signal sender)
                    conn.on('data', function (data) {
                        addMessage("<span class=\"peerMsg\">Peer:</span> " + data);
                    });
                    conn.on('close', function () {
                        status.innerHTML = "Connection closed";
                    });
                };

                /**
                 * Get first "GET style" parameter from href.
                 * This enables delivering an initial command upon page load.
                 *
                 * Would have been easier to use location.hash.
                 */
               
                /**
                 * Send a signal via the peer connection and add it to the log.
                 * This will only occur if the connection is still alive.
                 */
                 function signal(sigName) {
                    if (conn && conn.open) {
                        conn.send(sigName);
                        console.log(sigName + " signal sent");
                        addMessage(cueString + sigName);
                    } else {
                        console.log('Connection is closed');
                    }
                }

                        async function initCam(e) {
                        try {
                            videoStream = await navigator.mediaDevices.getUserMedia(constraints);
                              console.log('get stream from webcam');
                               e.target.disabled = true;
                              } catch (e) {
                                  console.log(e);
                              }
                            }

              
                callButton.addEventListener('click', function () {
        
                var videoStream;

                const constraints = window.constraints = {
                         audio: true,
                         video: true
                        };

                    var options = {
                        'constraints': {
                             'mandatory': {
                                 'OfferToReceiveAudio': true,
                                 'OfferToReceiveVideo': true
                                 }
                         }
                    }

                        var call = peer.call(conn.peer, stream,options);
                        call.on('stream', function(remoteStream) {
                          // Show stream in some video/canvas element.
                          console.log('show stream from reciever');

                          const video = document.querySelector('video');
                            video.srcObject = remoteStream;

                          });
                         }, function(err) {
                          console.log('Failed to get local stream' ,err);
                    });       
sendMessageBox.addEventListener('keypress', function (e) {
                    var event = e || window.event;
                    var char = event.which || event.keyCode;
                    if (char == '13')
                        sendButton.click();
                });
                // Send message
                sendButton.addEventListener('click', function () {
                    if (conn && conn.open) {
                        var msg = sendMessageBox.value;
                        sendMessageBox.value = "";
                        conn.send(msg);
                        console.log("Sent: " + msg)
                        addMessage("<span class=\"selfMsg\">Self: </span>" + msg);
                    } else {
                        console.log('Connection is closed');
                    }
                });
                
               
                function addMessage(msg) {
                    var now = new Date();
                    var h = now.getHours();
                    var m = addZero(now.getMinutes());
                    var s = addZero(now.getSeconds());

                    if (h > 12)
                        h -= 12;
                    else if (h === 0)
                        h = 12;

                    function addZero(t) {
                        if (t < 10)
                            t = "0" + t;
                        return t;
                    };

                    message.innerHTML = "<br><span class=\"msg-time\">" + h + ":" + m + ":" + s + "</span>  -  " + msg + message.innerHTML;
                };

                function clearMessages() {
                    message.innerHTML = "";
                    addMessage("Msgs cleared");
                };

               
               
                // Clear messages box
                clearMsgsButton.addEventListener('click', clearMessages);
                // Start peer connection on click
                //connectButton.addEventListener('click', join);

                setTimeout(function(){ 
                    //initCam();
                    join();
                     }, 500);

                    setTimeout(function(){ 
                    initCam();
                     }, 100);


                // Since all our callbacks are setup, start the process of obtaining an ID
                initialize();
                
            })();
        </script>