Contributing to yii2-sortable
=============================
Looking to contribute something to yii2-sortable? **Here's how you can help.**

Using the issue tracker
-----------------------
When [reporting bugs][reporting-bugs] or
[requesting features][requesting-features], the
[issue tracker on GitHub][issue-tracker] is the recommended channel to use.

The issue tracker **is not** a place for support requests. Refer the 
[extension documentation and demos](http://demos.krajee.com/sortable) and/or refer to the
[webtips Q & A forum](http://webtips.krajee.com/questions) which are the better places to get help.

How to contribute via a pull request?
-------------------------------------
Refer this [git workflow for contributors](.github/GIT-WORKFLOW.md).

Reporting bugs with yii2-sortable
---------------------------------
We really appreciate clear bug reports that _consistently_ show an issue
within _yii2-sortable_.

The ideal bug report follows these guidelines:

1. **Use the [GitHub issue search][issue-search]**  &mdash; Check if the issue
   has already been reported.
2. **Check if the issue has been fixed**  &mdash; Try to reproduce the problem
   using the code in the `master` branch.
3. **Isolate the problem**  &mdash; Try to share a demo or a test case that
   consistently reproduces the problem.

Please try to be as detailed as possible in your bug report, especially if an
isolated test case cannot be made. Some useful questions to include the answer
to are:

- What steps can be used to reproduce the issue?
- What is the bug and what is the expected outcome?
- What browser(s) and Operating System have you tested with?
- Does the bug happen consistently across all tested browsers?
- What version of jQuery are you using? And what version of yii2-sortable?
- Are you using yii2-sortable with other plugins?

All of these questions will help others fix and identify any potential bugs.

Requesting features in yii2-sortable
------------------------------------
Before starting work on a major feature for yii2-sortable, **read the
[documentation](http://demos.krajee.com/sortable)  first** or you may risk spending a considerable amount of
time on something which the project developers are not interested in bringing into the project.

Licensing
---------

It should also be made clear that **all code contributed to yii2-sortable** must be
licensable under the [BSD-3 license][licensing].  Code that cannot be released
under this license **cannot be accepted** into the project.

[issue-search]: https://github.com/kartik-v/yii2-sortable/search?q=&type=Issues
[issue-tracker]: https://github.com/kartik-v/yii2-sortable/issues
[licensing]: https://github.com/kartik-v/yii2-sortable/blob/master/LICENSE.md
[reporting-bugs]: #reporting-bugs-with-yii2-sortable
[requesting-features]: #requesting-features-in-yii2-sortable